/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.gui;

import LegendaryCardMaker.CustomCardMaker.CustomCardMakerFrame;
import LegendaryCardMaker.CustomCardMaker.gui.CustomTemplateEditMenu;
import LegendaryCardMaker.CustomCardMaker.structure.CustomCard;
import LegendaryCardMaker.CustomCardMaker.structure.CustomStructure;
import LegendaryCardMaker.CustomCardMaker.structure.CustomTemplate;
import LegendaryCardMaker.LegendaryCardMaker;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryItem;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class CustomTemplateList
extends JScrollPane {
    public List<CustomCard> cards = new ArrayList<CustomCard>();
    public List<CustomStructure> structures = new ArrayList<CustomStructure>();
    public List<LegendaryItem> items = new ArrayList<LegendaryItem>();
    public JList cardList;
    public DefaultListModel cardListModel;
    public List<CustomTemplate> templateList = new ArrayList<CustomTemplate>();
    public CustomTemplateEditMenu menu;

    public CustomTemplateList(CustomTemplate template, List<CustomCard> cards, List<CustomStructure> structures) {
        this.templateList.add(template);
        for (CustomCard customCard : cards) {
            if (!customCard.template.tab.equals(template.tab)) continue;
            this.cards.add(customCard);
        }
        for (CustomStructure customStructure : structures) {
            if (!customStructure.tab.equals(template.tab)) continue;
            this.structures.add(customStructure);
        }
        LegendaryCardMaker legendaryCardMaker = LegendaryCardMakerFrame.lcmf.lcm;
        this.cardListModel = new DefaultListModel();
        Collections.sort(this.cards, new CustomCard());
        for (CustomCard h : this.cards) {
            this.cardListModel.addElement(h);
        }
        this.cardList = new JList(this.cardListModel);
        this.cardList.setCellRenderer(new CustomCardListRenderer());
        this.cardList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2 && (index = list.locationToIndex(evt.getPoint())) >= 0) {
                    CustomCard cc = (CustomCard)list.getSelectedValue();
                    new CustomCardMakerFrame(cc);
                }
            }
        });
        this.setViewportView(this.cardList);
        this.menu = new CustomTemplateEditMenu(this);
    }

    public void addTemplate(CustomTemplate template, List<CustomCard> cards) {
        this.templateList.add(template);
        for (CustomCard cc : cards) {
            if (!cc.template.tab.equals(template.tab) || this.cards.contains(cc)) continue;
            this.cards.add(cc);
        }
        this.cardListModel.removeAllElements();
        Collections.sort(this.cards, new CustomCard());
        for (CustomCard h : this.cards) {
            this.cardListModel.addElement(h);
        }
        this.menu = new CustomTemplateEditMenu(this);
    }

    public void addStructure(CustomStructure structure) {
        if (structure.tab.equals(structure.tab) && !this.structures.contains(structure)) {
            this.structures.add(structure);
        }
        this.cardListModel.removeAllElements();
        Collections.sort(this.cards, new CustomCard());
        for (CustomCard h : this.cards) {
            this.cardListModel.addElement(h);
        }
        this.menu = new CustomTemplateEditMenu(this);
    }

    public void loadList(List<CustomCard> cards) {
        this.cards.clear();
        this.cardListModel.removeAllElements();
        for (CustomTemplate template : this.templateList) {
            for (CustomCard cc : cards) {
                if (!cc.template.tab.equals(template.tab) || this.cards.contains(cc)) continue;
                this.cards.add(cc);
                this.cardListModel.addElement(cc);
            }
        }
    }

    public void loadListStructures(List<CustomStructure> structures) {
        this.cards.clear();
        this.cardListModel.removeAllElements();
        for (CustomStructure cc : structures) {
            if (this.structures.contains(cc)) continue;
            this.structures.add(cc);
            this.cardListModel.addElement(cc);
        }
    }

    public CustomCard getSelectedCustomCard() {
        return (CustomCard)this.cardList.getSelectedValue();
    }

    public void removeCustomCard(CustomCard cc) {
        this.cards.remove(cc);
        this.cardListModel.removeElement(cc);
    }

    public class CustomCardListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CustomCard c = (CustomCard)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setHorizontalTextPosition(4);
            String s = c.getCardName();
            if (c.changed) {
                s = String.valueOf(s) + " *";
            }
            label.setText(s);
            return label;
        }
    }
}

